(
	-- Matte/Shadow/Reflection material
	--Currently implemented as a test w. ArchNDesign shader with matte-flag set only
	struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"019b2fab-058c-4877-8d02-e6c4b20ebe8f"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			if mtl.catch_reflections do (
				if mtl.refl_color_shader != undefined do 
					append res #("refl_color", mtl.refl_color_shader)
			)

			if mtl.bump != undefined do 
				append res #("normal_perturb", mtl.bump, "normalPerturb", 1)

			if mtl.bump_amount_shader != undefined and mtl.bump_amount_connected do 
				append res #("bump_amount", mtl.bump_amount_shader, "resultFloat")

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("diffuse_weight", mtl.ambient_intensity)
			append res #("diffuse",        mtl.ambient)

			if mtl.catch_reflections do (
				append res #("reflectivity",      1.0)

				append res #("refl_use_ior",      false)
				append res #("refl_exponent",     5.0)
				append res #("refl_curve_low",    1.0)
				append res #("refl_curve_high",   1.0)


				append res #("refl_color",        mtl.refl_color)
				append res #("refl_gloss",        mtl.refl_glossiness)
				append res #("anisotropy",        1.0)
			)

			append res #("refr_ior",          1.4)
			append res #("cutout_opacity",    mtl.opacity)

			append res #("bump_amount",       mtl.bump_amount)

			append res #("att:matte", true) -- Enabled Matte Mode

			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAUYGA01j+A677TqJEuYTkQAzZkq7D3p+mI
-- fvT1qjZ1TVUKZY96j5v5nR/IxgURXksT47RHqNblJQFRZ4mkc8q8/RVW3/U0HmQu
-- wdkoH3/ktgKP4omWAyv57s/apicVKMYMI46nshtcJkXs+vcF/V+0sb6M7Ajd/LXN
-- /5f2VNMwU1R8Zmx1O+di1z0iSi0fZ2emV+KpcJ3nOPISerScdBeL0h8AU2D5nSWZ
-- EngWiuZZONu1mxSHD/weyRaEOUzqHNnrL7ZpqCvu0Bu2raR9YsAOLr6gFuiU6AFA
-- iLuSw5Bi1Uuxa0T/2XbM38LvxW4bK5Tut5/L9+m4k8iPbvA5d+E3
-- -----END-SIGNATURE-----